
%NOLIST

;   FILENAME: DOS.EQU
;
;   Copyright (c) 1988, 1989 by Borland International, Inc.
;
;   Description: This include file contains symbolic equates representing the
;   DOS function calls and their associated services.

FUNCTION            EQU 021h ; Dos Function call
STDOUT                  EQU 001h ; File handle for Standard Output device
STDERR                  EQU 002h ; File handle for Standard Error device
TRUE                    EQU 0FFH
FALSE                   EQU 0H

PROGRAM_TERMINATE   EQU 000h ; Terminate the program
READ_KBD_ECHO       EQU 001h ; Read the keyboard and echo to the screen
WRITE_CHARACTER     EQU 002h ; Output a character
AUXILIARY_INPUT     EQU 003h ; Read character from auxiliary device
AUXILIARY_OUTPUT    EQU 004h ; Write a character to the auxiliary device
PRINTER_OUTPUT      EQU 005h ; Send character to standard list device
CONSOLE_IO          EQU 006h ; Console Input/Output
UNFILTERED_INPUT    EQU 007h ; Unfiltered character input without echo
CHARACTER_INPUT     EQU 008h ; Character input without echo
WRITE_STRING        EQU 009h ; Display a '$' terminated string
BUFFERED_INPUT      EQU 00Ah ; Read text and store it in a buffer
GET_INPUT_STATUS    EQU 00Bh ; Check if input is available
RESET_INPUT         EQU 00Ch ; Clear the input buffer and check for input
DISK_RESET          EQU 00Dh ; Flush all DOS file buffers to disk
CHANGE_DISK_DRIVE   EQU 00Eh ; Set the default disk drive
OPEN_FCB_FILE       EQU 00Fh ; Open a file using FCB's
CLOSE_FCB_FILE      EQU 010h ; Close a file that uses FCB's
FIND_FIRST_FCB      EQU 011h ; Search for the first matching file
FIND_NEXT_FCB       EQU 012h ; Find the next matching file
DELETE_FCB_FILE     EQU 013h ; Delete a file using FCB's
SEQUENTIAL_READ     EQU 014h ; Reads the next block from a fil
SEQUENTIAL_WRITE    EQU 015h ; Writes the next block of data to a file
CREATE_FCB_FILE     EQU 016h ; Create and/or open a file for i/o
RENAME_FCB_FILE     EQU 017h ; Rename a file using FCB's
GET_DISK_DRIVE      EQU 019h ; Get the current disk drive
SET_DTA             EQU 01Ah ; Set the Disk Transfer Area address
DEFAULT_DRIVE_INFO  EQU 01Bh ; Get allocation information for the default drive
DRIVE_INFO          EQU 01Ch ; Get allocation information for a specific drive
RANDOM_READ         EQU 021h ; Perform a random file read
RANDOM_WRITE        EQU 022h ; Perform random file write
GET_FILE_SIZE       EQU 023h ; Get file size in records
SET_RECORD_NUMBER   EQU 024h ; Set the random record number
SET_VECTOR          EQU 025h ; Set an interrupt vector
CREATE_PSP          EQU 026h ; Create a Program Segment Prefix(PSP)
RANDOM_BLOCK_READ   EQU 027h ; Random block read of a file
RANDOM_BLOCK_WRITE  EQU 028h ; Random block write to a file
PARSE_FILENAME      EQU 029h ; Parse a filename
GET_DATE            EQU 02Ah ; Get the DOS Date
SET_DATE            EQU 02Bh ; Set the DOS Date
GET_TIME            EQU 02Ch ; Get the DOS Time
SET_TIME            EQU 02Dh ; Set the DOS Time
SET_VERIFY_FLAG     EQU 02Eh ; Set the DOS verify flag
GET_DTA             EQU 02Fh ; Get the DTA address
GET_VERSION         EQU 030h ; Get the MS-DOS Version #
KEEP                EQU 031h ; Terminate and stay resident
GET_SET_CTRL_BREAK  EQU 033h ; Get or set the Ctrl-Break flag
GET_VECTOR          EQU 035h ; Get the interrupt vector
GET_DISK_SPACE      EQU 036h ; Returns allocation info. about a disk
GET_SET_COUNTRY     EQU 038h ; Get or set the current info. about the country
MAKE_DIRECTORY      EQU 039h ; Create a directory
DELETE_DIRECTORY    EQU 03Ah ; Delete a directory
SET_CURRENT_DIR     EQU 03Bh ; Set the current directory
CREATE_FILE         EQU 03Ch ; Create or truncate a file
OPEN_FILE           EQU 03Dh ; Open an existing file
CLOSE_FILE          EQU 03Eh ; Close a file
READ_FROM_HANDLE    EQU 03Fh ; Read from DOS file handle
WRITE_TO_HANDLE     EQU 040h ; Write to File Handle
DELETE_FILE         EQU 041h ; Delete a file
MOVE_FILE_POINTER   EQU 042h ; Move the file pointer
GET_SET_ATTRIBUTES  EQU 043h ; Get/Set File Attributes
IOCTL               EQU 044h ; Device-driver control
DUPLICATE_HANDLE    EQU 045h ; Duplicate file handle
FORCE_DUP_HANDLE    EQU 046h ; Force duplicate file handles
GET_DIRECTORY       EQU 047h ; Get the current directory
ALLOCATE_MEMORY     EQU 048h ; Allocate memory blocks
FREE_MEMORY         EQU 049h ; Release memory blocks
MODIFY_MEMORY       EQU 04Ah ; Modify a memory block
EXEC                EQU 04Bh ; Execute a program
TERMINATE_EXE       EQU 04Ch ; Terminate program
GET_RETURN_CODE     EQU 04Dh ; Get DOS return code
FIND_FIRST          EQU 04Eh ; Find first directory entry
FIND_NEXT           EQU 04Fh ; Find next directory entry
GET_VERIFY_FLAG     EQU 054h ; Get the value of DOS's verify flag
RENAME_FILE         EQU 056h ; Rename a file
GET_SET_DATE_TIME   EQU 057h ; Read or Modify the time and date of a file
GET_SET_ALLOCATION  EQU 058h ; Get or set DOS's memory allocation strategy
GET_EXTENDED_ERRORS EQU 059h ; Get more detailed info. about a DOS error
CREATE_TEMP_FILE    EQU 05Ah ; Create a temporary file
CREATE_NEW_FILE     EQU 05Bh ; Create a new file
CONTROL_ACCESS      EQU 05Ch ; Set access ability to a region in a file

NET_HARDWARE        EQU 05Eh ; Microsoft Network hardware info.

NET_GET_MACHINE_NAME    EQU 000h ; Get the name of the local machine
NET_SET_PRINTER_SETUP   EQU 002h ; Set the printer's setup
NET_GET_PRINTER_SETUP   EQU 003h ; Get the printer's setup

NET_SYSTEM          EQU 05Fh ; Microsoft Network system info.

NET_GET_REDIRECTION_LIST    EQU 002h ; Inspect the system redirection list
NET_REDIRECT_DEVICE         EQU 003h ; Redirect a device
NET_CANCEL_REDIRECT         EQU 004h ; Cancel the redirection of a device

GET_PSP             EQU 062h ; Get Program Segment Prefix(PSP)
GET_LEAD_BYTE_TABLE EQU 063h ; Get the address of the system table

DOS MACRO X
    MOV AH,X
    INT FUNCTION
ENDM

LOG2 MACRO X  ; CL:=LOG2(X)
LOCAL Y,L
  Y = 1
  L = 0
  REPT 17
    IF (Y EQ X)
       EXITM
    ENDIF
    Y=Y*2
    L=L+1
  ENDM
  IF L EQ 17
     %OUT WARNING: LOG2(X>2^16)
  ELSE
     MOV CL,L
  ENDIF
ENDM

PUSHR MACRO REGS
LOCAL REG
;; EXAPL: PUSHR <BX,AX,CX>
   IRP REG,<REGS>
     PUSH REG
   ENDM
ENDM

POPR  MACRO REGS
LOCAL REG
;; EXAPL: POPR  <BX,AX,CX>
   IRP REG,<REGS>
     POP  REG
   ENDM
ENDM

%LIST